/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionSerializable;
import com.nvidia.viper.model.ModelWithProperties;
import com.nvidia.viper.model.Session;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Element;

public class VerticalRuler
extends ModelWithProperties
implements IModel,
ISessionSerializable {
    public static final String PROPERTY_WIDTH = "vruler:width";
    public static final int DEFAULT_WIDTH = 200;
    public static final int MIN_WIDTH = 100;
    private Session session;
    private int width;

    public VerticalRuler(Session session) {
        this.session = session;
        this.width = 200;
    }

    public VerticalRuler(Session session, Element el) throws ViperException {
        this(session);
        this.read(el);
    }

    public Session getSession() {
        return this.session;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        if (this.width != width) {
            this.width = width;
            this.firePropertyChange(PROPERTY_WIDTH);
        }
    }

    @Override
    public void write(Writer w) throws ViperException {
        try {
            w.write("<vruler width=\"" + this.width + "\"/>\n");
        }
        catch (IOException e) {
            throw new ViperException(e);
        }
    }

    protected void read(Element el) throws ViperException {
        if (!"vruler".equals(el.getTagName())) {
            throw new ViperException("expected \"vruler\" tag, got " + el.getTagName());
        }
        this.width = Integer.parseInt(el.getAttribute("width"));
    }
}

