/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.jni;

import com.nvidia.viper.Activator;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.jni.NativeUtils;
import org.eclipse.core.runtime.Platform;

public class LibVp {
    private static boolean initialized = false;

    public static synchronized boolean initialize() {
        if (!initialized) {
            try {
                String libPrefix = NativeUtils.getSharedLibraryPrefix();
                String libExtension = NativeUtils.getBundledSharedLibraryExtension();
                String libName = "vp_" + Platform.getOS() + "_" + Platform.getOSArch();
                String libFullName = String.valueOf(libPrefix) + libName + libExtension;
                try {
                    System.loadLibrary(libName);
                }
                catch (Exception exception) {
                    System.load(libFullName);
                }
            }
            catch (UnsatisfiedLinkError e) {
                String title = ViperMessages.LibVp_Fail_Title;
                String message = ViperMessages.LibVp_Fail_Message;
                if (e.getLocalizedMessage().contains("cupti") || e.getLocalizedMessage().contains("CUPTI")) {
                    String targetPath = null;
                    if ("macosx".equals(Platform.getOS())) {
                        targetPath = "<CUDA_DIR>/targets/x86_64-darwin/lib";
                    } else if ("linux".equals(Platform.getOS())) {
                        targetPath = "<CUDA_DIR>/targets/x86_64-linux/lib";
                    }
                    title = "CUPTI Initialization Failed";
                    message = "Unable to locate CUPTI library. \n\nMake sure that the CUPTI library is on your library path. It is located in folder \n\n<CUDA_DIR>/extras/CUPTI/lib64";
                    if (targetPath != null) {
                        message = String.valueOf(message) + "\nOR\n" + targetPath;
                    }
                } else if ("win32".equals(Platform.getOS())) {
                    title = "Failed to find dependent DLL";
                    message = "Can't find dependent DLL. \n\nCheck that the CUPTI DLL is on your PATH environment. It is located in folder \n\n<CUDA_DIR>/extras/CUPTI/lib64";
                }
                Activator.getDefault().getViperWorkbench().informUnableToLoadLibraries(title, message);
            }
            catch (Exception ee) {
                Activator.getDefault().getViperWorkbench().informUnableToLoadLibraries(ee);
            }
            initialized = true;
        }
        return initialized;
    }
}

