/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Module;
import org.netbeans.Util;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.core.startup.layers.LocalFileSystemEx;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.spi.autoupdate.AutoupdateClusterCreator;
import org.netbeans.updater.UpdateTracking;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Lookup;

public class InstallManager
extends InstalledFileLocator {
    static final String NBM_LIB = "lib";
    static final String NBM_CORE = "core";
    static final String NETBEANS_DIRS = "netbeans.dirs";
    private static int countOfWarnings = 0;
    private static final int MAX_COUNT_OF_WARNINGS = 5;
    private static final Logger ERR = Logger.getLogger("org.netbeans.modules.autoupdate.services.InstallManager");
    private static final List<File> clusters = new ArrayList<File>();

    static File findTargetDirectory(UpdateElement updateElement, UpdateElementImpl updateElementImpl, Boolean bl, boolean bl2) throws OperationException {
        File file;
        boolean bl3;
        if (bl == null) {
            bl = InstallManager.isGlobalInstallation();
        }
        boolean bl4 = bl3 = bl == null ? false : bl;
        if (Boolean.FALSE.equals(bl)) {
            ERR.log(Level.INFO, "Forced installation in userdir only for " + updateElementImpl.getUpdateElement());
            return InstallManager.getUserDir();
        }
        if (updateElement != null) {
            file = InstallManager.getInstallDir(updateElement, updateElementImpl, bl3 |= updateElementImpl.getInstallInfo().isGlobal() != null && updateElementImpl.getInstallInfo().isGlobal() != false, bl2);
        } else {
            bl3 |= updateElementImpl.isFixed();
            String string = updateElementImpl.getInstallInfo().getTargetCluster();
            if (string != null && string.length() > 0 || (bl3 |= updateElementImpl.getInstallInfo().isGlobal() != null && updateElementImpl.getInstallInfo().isGlobal() != false)) {
                file = InstallManager.checkTargetCluster(updateElementImpl, string, bl3, bl2);
                if (file == null && string != null && (file = InstallManager.createNonExistingCluster(string)) != null) {
                    file = InstallManager.checkTargetCluster(updateElementImpl, string, bl3, bl2);
                }
                if (file == null) {
                    InstallManager.createNonExistingCluster("extra");
                    file = InstallManager.checkTargetCluster(updateElementImpl, "extra", bl3, bl2);
                    File file2 = file = file == null ? InstallManager.getUserDir() : file;
                    if (string != null) {
                        ERR.log(Level.INFO, "Declared target cluster " + string + " in " + updateElementImpl.getUpdateElement() + " wasn't found or was read only. Will be used " + file);
                    } else {
                        ERR.log(Level.INFO, file + " will be used as target cluster");
                    }
                }
            } else {
                file = InstallManager.getUserDir();
            }
        }
        ERR.log(Level.FINEST, "UpdateElement " + updateElementImpl.getUpdateElement() + " has the target cluster " + file);
        return file;
    }

    private static File checkTargetCluster(UpdateElementImpl updateElementImpl, String string, boolean bl, boolean bl2) throws OperationException {
        if (string == null || string.length() == 0) {
            return null;
        }
        File file = null;
        for (File file2 : UpdateTracking.clusters(true)) {
            boolean bl3;
            if (!string.equals(file2.getName())) continue;
            boolean bl4 = bl3 = !file2.exists();
            if (Utilities.canWriteInCluster(file2)) {
                if (bl3) {
                    file2.mkdirs();
                    InstallManager.extendSystemFileSystem(file2);
                }
                file = file2;
                break;
            }
            if (!bl2 && bl) {
                ERR.log(Level.WARNING, "There is no write permission to write in target cluster " + string + " for " + updateElementImpl.getUpdateElement());
                throw new OperationException(OperationException.ERROR_TYPE.WRITE_PERMISSION, updateElementImpl.getCodeName());
            }
            if (countOfWarnings++ < 5) {
                ERR.log(Level.WARNING, "There is no write permission to write in target cluster " + string + " for " + updateElementImpl.getUpdateElement());
            }
            if (countOfWarnings != 5) break;
            ERR.log(Level.WARNING, "There is no write permission to write in target cluster " + string + " for more updates or plugins.");
            break;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createNonExistingCluster(String string) {
        File file = null;
        for (AutoupdateClusterCreator autoupdateClusterCreator : Lookup.getDefault().lookupAll(AutoupdateClusterCreator.class)) {
            File file2 = Trampoline.SPI.findCluster(string, autoupdateClusterCreator);
            if (file2 == null) continue;
            try {
                ERR.log(Level.FINE, "Found cluster candidate " + file2 + " for declared target cluster " + string);
                File[] fileArray = Trampoline.SPI.registerCluster(string, file2, autoupdateClusterCreator);
                file = file2;
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = "";
                for (File file3 : fileArray) {
                    stringBuffer.append(string2);
                    stringBuffer.append(file3.getPath());
                    string2 = File.pathSeparator;
                }
                System.setProperty(NETBEANS_DIRS, stringBuffer.toString());
                File file4 = new File(new File(InstallManager.getUserDir(), Utilities.DOWNLOAD_DIR), NETBEANS_DIRS);
                if (!file4.exists()) {
                    file4.getParentFile().mkdirs();
                    file4.createNewFile();
                }
                try (FileOutputStream fileOutputStream = new FileOutputStream(file4);){
                    ((OutputStream)fileOutputStream).write(stringBuffer.toString().getBytes());
                }
                ERR.log(Level.FINE, "Was written new netbeans.dirs " + stringBuffer);
                break;
            }
            catch (IOException iOException) {
                ERR.log(Level.INFO, iOException.getMessage(), iOException);
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extendSystemFileSystem(File file) {
        try {
            File file2 = new File(file, "config");
            file2.mkdir();
            LocalFileSystemEx localFileSystemEx = new LocalFileSystemEx();
            localFileSystemEx.setRootDirectory(file2);
            MainLookup.register((Object)localFileSystemEx);
            Class<InstallManager> clazz = InstallManager.class;
            synchronized (InstallManager.class) {
                clusters.add(file);
                // ** MonitorExit[var3_5] (shouldn't be in output)
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            ERR.log(Level.INFO, propertyVetoException.getMessage(), propertyVetoException);
        }
        catch (IOException iOException) {
            ERR.log(Level.INFO, iOException.getMessage(), iOException);
        }
        {
            return;
        }
    }

    private static File getInstallDir(UpdateElement updateElement, UpdateElementImpl updateElementImpl, boolean bl, boolean bl2) throws OperationException {
        File file;
        block9: {
            File file2;
            block8: {
                file = null;
                UpdateElementImpl updateElementImpl2 = Trampoline.API.impl(updateElement);
                assert (updateElementImpl2 instanceof ModuleUpdateElementImpl) : "Impl of " + updateElement + " instanceof ModuleUpdateElementImpl";
                Module module = Utilities.toModule(((ModuleUpdateElementImpl)updateElementImpl2).getModuleInfo());
                File file3 = file2 = module == null ? null : module.getJarFile();
                if (file2 != null) break block8;
                ERR.log(Level.FINE, "No install dir for " + updateElement + " (It's ok for fixed). Is fixed? " + Trampoline.API.impl(updateElement).isFixed());
                String string = updateElementImpl.getInstallInfo().getTargetCluster();
                if (string != null) {
                    for (File file4 : UpdateTracking.clusters(false)) {
                        if (!string.equals(file4.getName())) continue;
                        file = file4;
                        break;
                    }
                }
                if (file != null) break block9;
                file = UpdateTracking.getPlatformDir();
                break block9;
            }
            for (File file5 : UpdateTracking.clusters(true)) {
                if (!InstallManager.isParentOf(file5 = FileUtil.normalizeFile((File)file5), file2)) continue;
                file = file5;
                break;
            }
        }
        if (file == null || !Utilities.canWriteInCluster(file)) {
            if (!bl2 && bl) {
                ERR.log(Level.WARNING, "There is no write permission to write in target cluster " + file + " for " + updateElementImpl.getUpdateElement());
                throw new OperationException(OperationException.ERROR_TYPE.WRITE_PERMISSION, updateElementImpl.getCodeName());
            }
            if (countOfWarnings++ < 5) {
                ERR.log(Level.WARNING, "There is no write permission to write in target cluster " + file + " for " + updateElementImpl.getUpdateElement());
            }
            if (countOfWarnings == 5) {
                ERR.log(Level.WARNING, "There is no write permission to write in target cluster " + file + " for more updates or plugins.");
            }
            file = UpdateTracking.getUserDir();
        }
        ERR.log(Level.FINEST, "Install dir of " + updateElement + " is " + file);
        return file;
    }

    private static boolean isParentOf(File file, File file2) {
        File file3;
        for (file3 = file2.getParentFile(); file3 != null && !file.equals(file3); file3 = file3.getParentFile()) {
        }
        return file3 != null;
    }

    static File getUserDir() {
        return UpdateTracking.getUserDir();
    }

    static boolean needsRestart(boolean bl, UpdateElementImpl updateElementImpl, File file) {
        boolean bl2;
        assert (updateElementImpl.getInstallInfo() != null) : "Each UpdateElement must know own InstallInfo but " + updateElementImpl;
        boolean bl3 = updateElementImpl.getInstallInfo().needsRestart() != null && updateElementImpl.getInstallInfo().needsRestart() != false;
        boolean bl4 = bl2 = bl3 || bl;
        if (!bl2) {
            bl2 = InstallManager.willInstallInSystem(file);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean willInstallInSystem(File file) {
        boolean bl = false;
        try (JarFile jarFile = new JarFile(file);){
            for (JarEntry jarEntry : Collections.list(jarFile.entries())) {
                String string = jarEntry.getName();
                if (!string.startsWith("core/") && !string.startsWith("lib/")) continue;
                bl = true;
                break;
            }
        }
        catch (IOException iOException) {
            ERR.log(Level.INFO, iOException.getMessage(), iOException);
        }
        return bl;
    }

    public File locate(String string, String string2, boolean bl) {
        Set<File> set = this.locateAll(string, string2, bl);
        return set.isEmpty() ? null : set.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<File> locateAll(String string, String string2, boolean bl) {
        Class<InstallManager> clazz = InstallManager.class;
        synchronized (InstallManager.class) {
            String string3;
            String string4;
            if (clusters.isEmpty()) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return Collections.emptySet();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (string.length() == 0) {
                throw new IllegalArgumentException("Cannot look up \"\" in InstalledFileLocator.locate");
            }
            if (string.charAt(0) == '/') {
                throw new IllegalArgumentException("Paths passed to InstalledFileLocator.locate should not start with '/': " + string);
            }
            int n = string.lastIndexOf(47);
            if (n == string.length() - 1) {
                throw new IllegalArgumentException("Paths passed to InstalledFileLocator.locate should not end in '/': " + string);
            }
            if (n != -1) {
                string4 = string.substring(0, n + 1);
                string3 = string.substring(n + 1);
                assert (string3.length() > 0);
            } else {
                string4 = "";
                string3 = string;
            }
            if (bl) {
                String string5;
                String string6;
                int n2 = string3.lastIndexOf(46);
                if (n2 == -1) {
                    string6 = string3;
                    string5 = "";
                } else {
                    string6 = string3.substring(0, n2);
                    string5 = string3.substring(n2);
                }
                String[] stringArray = Util.getLocalizingSuffixesFast();
                HashSet<File> hashSet = new HashSet<File>();
                for (String string7 : stringArray) {
                    String string8 = string6 + string7 + string5;
                    hashSet.addAll(InstallManager.locateExactPath(string4, string8));
                }
                return hashSet;
            }
            return InstallManager.locateExactPath(string4, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<File> locateExactPath(String string, String string2) {
        HashSet<File> hashSet = new HashSet<File>();
        Class<InstallManager> clazz = InstallManager.class;
        synchronized (InstallManager.class) {
            File[] fileArray;
            for (File file : fileArray = clusters.toArray(new File[0])) {
                File file2 = InstallManager.makeFile(file, string, string2);
                if (!file2.exists()) continue;
                hashSet.add(file2);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return hashSet;
        }
    }

    private static File makeFile(File file, String string, String string2) {
        return FileUtil.normalizeFile((File)new File(file, string.replace('/', File.separatorChar) + string2));
    }

    private static Boolean isGlobalInstallation() {
        String string = System.getProperty("plugin.manager.install.global");
        if (Boolean.parseBoolean(string)) {
            return Boolean.TRUE;
        }
        if (Boolean.FALSE.toString().equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        return null;
    }
}

