/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.geom;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.ULine;

public class XLine2D
implements UDrawable {
    public final double x1;
    public final double y1;
    public final double x2;
    public final double y2;

    public XLine2D(double x1, double y1, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public static XLine2D line(XPoint2D p1, XPoint2D p2) {
        return new XLine2D(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public XPoint2D getMiddle() {
        double mx = (this.x1 + this.x2) / 2.0;
        double my = (this.y1 + this.y2) / 2.0;
        return new XPoint2D(mx, my);
    }

    public final double getX1() {
        return this.x1;
    }

    public final double getY1() {
        return this.y1;
    }

    public final double getX2() {
        return this.x2;
    }

    public final double getY2() {
        return this.y2;
    }

    public XPoint2D getP1() {
        return new XPoint2D(this.x1, this.y1);
    }

    public XPoint2D getP2() {
        return new XPoint2D(this.x2, this.y2);
    }

    public XLine2D withPoint1(XPoint2D other) {
        return new XLine2D(other.x, other.y, this.x2, this.y2);
    }

    public XLine2D withPoint2(XPoint2D other) {
        return new XLine2D(this.x1, this.y1, other.x, other.y);
    }

    public static double ptSegDistSq(double x1, double y1, double x2, double y2, double px, double py) {
        double projlenSq;
        double lenSq;
        double dotprod = (px -= x1) * (x2 -= x1) + (py -= y1) * (y2 -= y1);
        if ((lenSq = px * px + py * py - (projlenSq = dotprod <= 0.0 ? 0.0 : ((dotprod = (px = x2 - px) * x2 + (py = y2 - py) * y2) <= 0.0 ? 0.0 : dotprod * dotprod / (x2 * x2 + y2 * y2)))) < 0.0) {
            lenSq = 0.0;
        }
        return lenSq;
    }

    public XPoint2D intersect(XLine2D line2) {
        double s1x = this.x2 - this.x1;
        double s1y = this.y2 - this.y1;
        double s2x = line2.x2 - line2.x1;
        double s2y = line2.y2 - line2.y1;
        double s2 = (-s1y * (this.x1 - line2.x1) + s1x * (this.y1 - line2.y1)) / (-s2x * s1y + s1x * s2y);
        double t2 = (s2x * (this.y1 - line2.y1) - s2y * (this.x1 - line2.x1)) / (-s2x * s1y + s1x * s2y);
        if (s2 >= 0.0 && s2 <= 1.0 && t2 >= 0.0 && t2 <= 1.0) {
            return new XPoint2D(this.x1 + t2 * s1x, this.y1 + t2 * s1y);
        }
        return null;
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(new UTranslate(this.x1, this.y1));
        ULine line = new ULine(this.x2 - this.x1, this.y2 - this.y1);
        ug.draw(line);
    }

    public double getAngle() {
        return Math.atan2(this.y2 - this.y1, this.x2 - this.x1);
    }
}

