/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.utils;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptService;
import org.opensearch.script.ScriptType;
import org.opensearch.script.TemplateScript;

public class ScriptUtils {
    public static Optional<String> executePreprocessFunction(ScriptService scriptService, String preProcessFunction, List<String> inputSentences) {
        return Optional.ofNullable(ScriptUtils.executeScript(scriptService, preProcessFunction, (Map<String, Object>)ImmutableMap.of((Object)"text_docs", inputSentences)));
    }

    public static Optional<String> executePostProcessFunction(ScriptService scriptService, String postProcessFunction, String resultJson) {
        Map result = StringUtils.fromJson((String)resultJson, (String)"result");
        if (postProcessFunction != null) {
            return Optional.ofNullable(ScriptUtils.executeScript(scriptService, StringUtils.addDefaultMethod((String)postProcessFunction), result));
        }
        return Optional.empty();
    }

    public static String executeScript(ScriptService scriptService, String painlessScript, Map<String, Object> params) {
        Script script = new Script(ScriptType.INLINE, "painless", painlessScript, Collections.emptyMap());
        TemplateScript templateScript = ((TemplateScript.Factory)scriptService.compile(script, TemplateScript.CONTEXT)).newInstance(params);
        return templateScript.execute();
    }
}

