"use strict";
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.lexerRules = exports.ID = void 0;
const monaco_1 = require("../../monaco");
exports.ID = 'PPL';
const brackets = [
    { open: '[', close: ']', token: 'delimiter.square' },
    { open: '(', close: ')', token: 'delimiter.parenthesis' },
];
const keywords = [
    // COMMAND KEYWORDS
    'SEARCH',
    'DESCRIBE',
    'SHOW',
    'FROM',
    'WHERE',
    'FIELDS',
    'RENAME',
    'STATS',
    'DEDUP',
    'SORT',
    'EVAL',
    'HEAD',
    'TOP',
    'RARE',
    'PARSE',
    'METHOD',
    'REGEX',
    'PUNCT',
    'GROK',
    'PATTERN',
    'PATTERNS',
    'NEW_FIELD',
    'KMEANS',
    'AD',
    'ML',
    // COMMAND ASSIST KEYWORDS
    'AS',
    'BY',
    'SOURCE',
    'INDEX',
    'D',
    'DESC',
    'DATASOURCES',
    // CLAUSE KEYWORDS
    'SORTBY',
    // FIELD KEYWORDS
    'AUTO',
    'STR',
    'IP',
    'NUM',
    // ARGUMENT KEYWORDS
    'KEEPEMPTY',
    'CONSECUTIVE',
    'DEDUP_SPLITVALUES',
    'PARTITIONS',
    'ALLNUM',
    'DELIM',
    'CENTROIDS',
    'ITERATIONS',
    'DISTANCE_TYPE',
    'NUMBER_OF_TREES',
    'SHINGLE_SIZE',
    'SAMPLE_SIZE',
    'OUTPUT_AFTER',
    'TIME_DECAY',
    'ANOMALY_RATE',
    'CATEGORY_FIELD',
    'TIME_FIELD',
    'TIME_ZONE',
    'TRAINING_DATA_SIZE',
    'ANOMALY_SCORE_THRESHOLD',
    // COMPARISON FUNCTION KEYWORDS
    'CASE',
    'IN',
    // LOGICAL KEYWORDS
    'NOT',
    'OR',
    'AND',
    'XOR',
    'TRUE',
    'FALSE',
    'REGEXP',
    // DATETIME, INTERVAL AND UNIT KEYWORDS
    'CONVERT_TZ',
    'DATETIME',
    'DAY',
    'DAY_HOUR',
    'DAY_MICROSECOND',
    'DAY_MINUTE',
    'DAY_OF_YEAR',
    'DAY_SECOND',
    'HOUR',
    'HOUR_MICROSECOND',
    'HOUR_MINUTE',
    'HOUR_OF_DAY',
    'HOUR_SECOND',
    'INTERVAL',
    'MICROSECOND',
    'MILLISECOND',
    'MINUTE',
    'MINUTE_MICROSECOND',
    'MINUTE_OF_DAY',
    'MINUTE_OF_HOUR',
    'MINUTE_SECOND',
    'MONTH',
    'MONTH_OF_YEAR',
    'QUARTER',
    'SECOND',
    'SECOND_MICROSECOND',
    'SECOND_OF_MINUTE',
    'WEEK',
    'WEEK_OF_YEAR',
    'YEAR',
    'YEAR_MONTH',
    // DATASET TYPES
    'DATAMODEL',
    'LOOKUP',
    'SAVEDSEARCH',
    // CONVERTED DATA TYPES
    'INT',
    'INTEGER',
    'DOUBLE',
    'LONG',
    'FLOAT',
    'STRING',
    'BOOLEAN',
    // SPECIAL CHARACTERS AND OPERATORS
    'PIPE',
    'COMMA',
    'DOT',
    'EQUAL',
    'GREATER',
    'LESS',
    'NOT_GREATER',
    'NOT_LESS',
    'NOT_EQUAL',
    'PLUS',
    'MINUS',
    'STAR',
    'DIVIDE',
    'MODULE',
    'EXCLAMATION_SYMBOL',
    'COLON',
    'LT_PRTHS',
    'RT_PRTHS',
    'LT_SQR_PRTHS',
    'RT_SQR_PRTHS',
    'SINGLE_QUOTE',
    'DOUBLE_QUOTE',
    'BACKTICK',
    // AGGREGATIONS
    'AVG',
    'COUNT',
    'DISTINCT_COUNT',
    'ESTDC',
    'ESTDC_ERROR',
    'MAX',
    'MEAN',
    'MEDIAN',
    'MIN',
    'MODE',
    'RANGE',
    'STDEV',
    'STDEVP',
    'SUM',
    'SUMSQ',
    'VAR_SAMP',
    'VAR_POP',
    'STDDEV_SAMP',
    'STDDEV_POP',
    'PERCENTILE',
    'TAKE',
    'FIRST',
    'LAST',
    'LIST',
    'VALUES',
    'EARLIEST',
    'EARLIEST_TIME',
    'LATEST',
    'LATEST_TIME',
    'PER_DAY',
    'PER_HOUR',
    'PER_MINUTE',
    'PER_SECOND',
    'RATE',
    'SPARKLINE',
    'C',
    'DC',
    // BASIC FUNCTIONS
    'ABS',
    'CBRT',
    'CEIL',
    'CEILING',
    'CONV',
    'CRC32',
    'E',
    'EXP',
    'FLOOR',
    'LN',
    'LOG',
    'LOG10',
    'LOG2',
    'MOD',
    'PI',
    'POSITION',
    'POW',
    'POWER',
    'RAND',
    'ROUND',
    'SIGN',
    'SQRT',
    'TRUNCATE',
    // TRIGONOMETRIC FUNCTIONS
    'ACOS',
    'ASIN',
    'ATAN',
    'ATAN2',
    'COS',
    'COT',
    'DEGREES',
    'RADIANS',
    'SIN',
    'TAN',
    // DATE AND TIME FUNCTIONS
    'ADDDATE',
    'ADDTIME',
    'CURDATE',
    'CURRENT_DATE',
    'CURRENT_TIME',
    'CURRENT_TIMESTAMP',
    'CURTIME',
    'DATE',
    'DATEDIFF',
    'DATE_ADD',
    'DATE_FORMAT',
    'DATE_SUB',
    'DAYNAME',
    'DAYOFMONTH',
    'DAYOFWEEK',
    'DAYOFYEAR',
    'DAY_OF_MONTH',
    'DAY_OF_WEEK',
    'DAY_OF_YEAR',
    'EXTRACT',
    'FROM_DAYS',
    'FROM_UNIXTIME',
    'GET_FORMAT',
    'LAST_DAY',
    'LOCALTIME',
    'LOCALTIMESTAMP',
    'MAKEDATE',
    'MAKETIME',
    'MONTHNAME',
    'NOW',
    'PERIOD_ADD',
    'PERIOD_DIFF',
    'SEC_TO_TIME',
    'STR_TO_DATE',
    'SUBDATE',
    'SUBTIME',
    'SYSDATE',
    'TIME',
    'TIMEDIFF',
    'TIMESTAMP',
    'TIMESTAMPADD',
    'TIMESTAMPDIFF',
    'TIME_FORMAT',
    'TIME_TO_SEC',
    'TO_DAYS',
    'TO_SECONDS',
    'UNIX_TIMESTAMP',
    'UTC_DATE',
    'UTC_TIME',
    'UTC_TIMESTAMP',
    'WEEKDAY',
    'YEARWEEK',
    // TEXT FUNCTIONS
    'SUBSTR',
    'SUBSTRING',
    'LTRIM',
    'RTRIM',
    'TRIM',
    'TO',
    'LOWER',
    'UPPER',
    'CONCAT',
    'CONCAT_WS',
    'LENGTH',
    'STRCMP',
    'RIGHT',
    'LEFT',
    'ASCII',
    'LOCATE',
    'REPLACE',
    'REVERSE',
    'CAST',
    // BOOL FUNCTIONS
    'LIKE',
    'ISNULL',
    'ISNOTNULL',
    // FLOWCONTROL FUNCTIONS
    'IFNULL',
    'NULLIF',
    'IF',
    'TYPEOF',
    // RELEVANCE FUNCTIONS AND PARAMETERS
    'MATCH',
    'MATCH_PHRASE',
    'MATCH_PHRASE_PREFIX',
    'MATCH_BOOL_PREFIX',
    'SIMPLE_QUERY_STRING',
    'MULTI_MATCH',
    'QUERY_STRING',
    'ALLOW_LEADING_WILDCARD',
    'ANALYZE_WILDCARD',
    'ANALYZER',
    'AUTO_GENERATE_SYNONYMS_PHRASE_QUERY',
    'BOOST',
    'CUTOFF_FREQUENCY',
    'DEFAULT_FIELD',
    'DEFAULT_OPERATOR',
    'ENABLE_POSITION_INCREMENTS',
    'ESCAPE',
    'FLAGS',
    'FUZZY_MAX_EXPANSIONS',
    'FUZZY_PREFIX_LENGTH',
    'FUZZY_TRANSPOSITIONS',
    'FUZZY_REWRITE',
    'FUZZINESS',
    'LENIENT',
    'LOW_FREQ_OPERATOR',
    'MAX_DETERMINIZED_STATES',
    'MAX_EXPANSIONS',
    'MINIMUM_SHOULD_MATCH',
    'OPERATOR',
    'PHRASE_SLOP',
    'PREFIX_LENGTH',
    'QUOTE_ANALYZER',
    'QUOTE_FIELD_SUFFIX',
    'REWRITE',
    'SLOP',
    'TIE_BREAKER',
    'TYPE',
    'ZERO_TERMS_QUERY',
    // SPAN KEYWORDS
    'SPAN',
    'MS',
    'S',
    'M',
    'H',
    'W',
    'Q',
    'Y',
];
const builtinFunctions = [
    'ABS',
    'CBRT',
    'CEIL',
    'CEILING',
    'CONV',
    'CRC32',
    'E',
    'EXP',
    'FLOOR',
    'LN',
    'LOG',
    'LOG10',
    'LOG2',
    'MOD',
    'PI',
    'POSITION',
    'POW',
    'POWER',
    'RAND',
    'ROUND',
    'SIGN',
    'SQRT',
    'TRUNCATE',
    'ACOS',
    'ASIN',
    'ATAN',
    'ATAN2',
    'COS',
    'COT',
    'DEGREES',
    'RADIANS',
    'SIN',
    'TAN',
    'ADDDATE',
    'ADDTIME',
    'CURDATE',
    'CURRENT_DATE',
    'CURRENT_TIME',
    'CURRENT_TIMESTAMP',
    'CURTIME',
    'DATE',
    'DATEDIFF',
    'DATE_ADD',
    'DATE_FORMAT',
    'DATE_SUB',
    'DAYNAME',
    'DAYOFMONTH',
    'DAYOFWEEK',
    'DAYOFYEAR',
    'DAY_OF_MONTH',
    'DAY_OF_WEEK',
    'DAY_OF_YEAR',
    'EXTRACT',
    'FROM_DAYS',
    'FROM_UNIXTIME',
    'GET_FORMAT',
    'LAST_DAY',
    'LOCALTIME',
    'LOCALTIMESTAMP',
    'MAKEDATE',
    'MAKETIME',
    'MONTHNAME',
    'NOW',
    'PERIOD_ADD',
    'PERIOD_DIFF',
    'SEC_TO_TIME',
    'STR_TO_DATE',
    'SUBDATE',
    'SUBTIME',
    'SYSDATE',
    'TIME',
    'TIMEDIFF',
    'TIMESTAMP',
    'TIMESTAMPADD',
    'TIMESTAMPDIFF',
    'TIME_FORMAT',
    'TIME_TO_SEC',
    'TO_DAYS',
    'TO_SECONDS',
    'UNIX_TIMESTAMP',
    'UTC_DATE',
    'UTC_TIME',
    'UTC_TIMESTAMP',
    'WEEKDAY',
    'YEARWEEK',
];
exports.lexerRules = {
    defaultToken: 'invalid',
    ignoreCase: true,
    tokenPostfix: '',
    keywords,
    builtinFunctions,
    brackets,
    tokenizer: {
        root: [
            [
                /[a-zA-Z_$][a-zA-Z0-9_$]*\b/,
                {
                    cases: {
                        '@keywords': 'keyword',
                        '@builtinFunctions': 'identifier',
                        '@default': 'identifier',
                    },
                },
            ],
            [/[()]/, '@brackets'],
            [/--.*$/, 'comment'],
            [/\/\*/, 'comment', '@comment'],
            [/\/.*$/, 'comment'],
            [/".*?"/, 'string'],
            [/'.*?'/, 'constant'],
            [/`.*?`/, 'string'],
            // whitespace
            [/[ \t\r\n]+/, { token: '@whitespace' }],
            [/[+-]?\d+(?:(?:\.\d*)?(?:[eE][+-]?\d+)?)?\b/, 'number'],
            [/⇐|<⇒|\*|\.|\:\:|\+|\-|\/|\/\/|%|&|\^|~|<|>|<=|=>|==|!=|<>|=/, 'keyword.operator'],
            [/[\(]/, 'paren.lparen'],
            [/[\)]/, 'paren.rparen'],
            [/\s+/, 'text'],
        ],
        numbers: [
            [/0[xX][0-9a-fA-F]*/, 'number'],
            [/[$][+-]*\d*(\.\d*)?/, 'number'],
            [/((\d+(\.\d*)?)|(\.\d+))([eE][\-+]?\d+)?/, 'number'],
        ],
        strings: [
            [/N'/, { token: 'string', next: '@string' }],
            [/'/, { token: 'string', next: '@string' }],
        ],
        string: [
            [/[^']+/, 'string'],
            [/''/, 'string'],
            [/'/, { token: 'string', next: '@pop' }],
        ],
        comment: [
            [/[^\/*]+/, 'comment'],
            [/\*\//, 'comment', '@pop'],
            [/[\/*]/, 'comment'],
        ],
    },
};
monaco_1.monaco.languages.register({
    id: exports.ID,
});
//# sourceMappingURL=opensearchppl.js.map