<?php

declare(strict_types=1);

/**
 * SPDX-FileCopyrightText: 2024 Nextcloud GmbH and Nextcloud contributors
 * SPDX-License-Identifier: AGPL-3.0-or-later
 */

namespace OCA\Mail\Migration;

use Closure;
use OCP\DB\ISchemaWrapper;
use OCP\DB\Types;
use OCP\Migration\IOutput;
use OCP\Migration\SimpleMigrationStep;

class Version4001Date20241009140707 extends SimpleMigrationStep {


	/**
	 * @param IOutput $output
	 * @param Closure(): ISchemaWrapper $schemaClosure
	 * @param array $options
	 * @return null|ISchemaWrapper
	 */
	public function changeSchema(IOutput $output, Closure $schemaClosure, array $options): ?ISchemaWrapper {
		
		$schema = $schemaClosure();

		$messagesTable = $schema->getTable('mail_messages');
		if (!$messagesTable->hasColumn('mentions_me')) {
			$messagesTable->addColumn('mentions_me', Types::BOOLEAN, [
				'notnull' => false,
				'default' => false,
			]);
		}
		
		return $schema;
	}

}
