/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Transforms;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java2d.ControlsSurface;
import java2d.CustomControls;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class Rotate
extends ControlsSurface {
    protected double increment = 5.0;
    protected int emphasis = 9;

    public Rotate() {
        this.setBackground(Color.WHITE);
        this.setControls(new Component[]{new DemoControls(this)});
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        int size = Math.min(w, h);
        float ew = size / 4;
        float eh = size - 20;
        Ellipse2D.Float ellipse = new Ellipse2D.Float(-ew / 2.0f, -eh / 2.0f, ew, eh);
        for (double angdeg = 0.0; angdeg < 360.0; angdeg += this.increment) {
            if (angdeg % (double)this.emphasis == 0.0) {
                g2.setColor(Color.GRAY);
                g2.setStroke(new BasicStroke(2.0f));
            } else {
                g2.setColor(Color.LIGHT_GRAY);
                g2.setStroke(new BasicStroke(0.5f));
            }
            AffineTransform at = AffineTransform.getTranslateInstance(w / 2, h / 2);
            at.rotate(Math.toRadians(angdeg));
            g2.draw(at.createTransformedShape(ellipse));
        }
        g2.setColor(Color.BLUE);
        ((RectangularShape)ellipse).setFrame(w / 2 - 10, h / 2 - 10, 20.0, 20.0);
        g2.fill(ellipse);
        g2.setColor(Color.GRAY);
        g2.setStroke(new BasicStroke(6.0f));
        g2.draw(ellipse);
        g2.setColor(Color.YELLOW);
        g2.setStroke(new BasicStroke(4.0f));
        g2.draw(ellipse);
        g2.setColor(Color.BLACK);
        g2.drawString("Rotate", 5, 15);
    }

    public static void main(String[] s) {
        Rotate.createDemoFrame(new Rotate());
    }

    static class DemoControls
    extends CustomControls
    implements ActionListener {
        Rotate demo;
        JTextField tf1;
        JTextField tf2;

        public DemoControls(Rotate demo) {
            super(demo.name);
            this.demo = demo;
            JLabel l = new JLabel("Increment:");
            l.setForeground(Color.BLACK);
            this.add(l);
            this.tf1 = new JTextField("5.0");
            this.add(this.tf1);
            this.tf1.setPreferredSize(new Dimension(30, 24));
            this.tf1.addActionListener(this);
            l = new JLabel("  Emphasis:");
            this.add(l);
            l.setForeground(Color.BLACK);
            this.tf2 = new JTextField("9");
            this.add(this.tf2);
            this.tf2.setPreferredSize(new Dimension(30, 24));
            this.tf2.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (e.getSource().equals(this.tf1)) {
                    this.demo.increment = Double.parseDouble(this.tf1.getText().trim());
                    if (this.demo.increment < 1.0) {
                        this.demo.increment = 1.0;
                    }
                } else {
                    this.demo.emphasis = Integer.parseInt(this.tf2.getText().trim());
                }
                this.demo.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(200, 39);
        }

        @Override
        public void run() {
            Thread me = Thread.currentThread();
            while (this.thread == me) {
                for (int i = 3; i < 13; i += 3) {
                    try {
                        Thread.sleep(4444L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    this.tf1.setText(String.valueOf(i));
                    this.demo.increment = i;
                    this.demo.repaint();
                }
            }
            this.thread = null;
        }
    }
}

