/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __UOSIMAP_H__
#define __UOSIMAP_H__

#include "libsylph/imap.h"

#include "uosfolder.h"
#include "uossession.h"
#include "uosprocmsg.h"

typedef IMAPFolder UosIMAPFolder;
typedef IMAPSession UosIMAPSession;
typedef IMAPNameSpace UosIMAPNameSpace;

#define UOSIMAP_FOLDER(obj) IMAP_FOLDER(obj)
#define UOSIMAP_SESSION(obj) IMAP_SESSION(obj)

#include "uosprefs_account.h"

typedef IMAPAuthType UosIMAPAuthType;

#define UOSIMAP_SUCCESS IMAP_SUCCESS
#define UOSIMAP_SOCKET IMAP_SOCKET
#define UOSIMAP_AUTHFAIL IMAP_AUTHFAIL
#define UOSIMAP_PROTOCOL IMAP_PROTOCOL
#define UOSIMAP_SYNTAX IMAP_SYNTAX
#define UOSIMAP_IOERR IMAP_IOERR
#define UOSIMAP_ERROR IMAP_ERROR
#define UOSIMAP_EAGAIN IMAP_EAGAIN

#define UOSIMAPBUFSIZE IMAPBUFSIZE

typedef IMAPFlags UosIMAPFlags;

typedef void (*ImapGetUncachedMessagesProgressFunc)(long sin, gchar *uid, MsgInfo *msginfo, int cur, int total);
typedef void (*ImapRemoveItemFunc)(FolderItem *old_item);
typedef gboolean (*ImapCheckItemCanRemoveFunc)(FolderItem *old_item, gboolean ifget);

#define UOSIMAP_IS_SEEN(flags) IMAP_IS_SEEN(flags)
#define UOSIMAP_IS_ANSWERED(flags) IMAP_IS_ANSWERED(flags)
#define UOSIMAP_IS_FLAGGED(flags) IMAP_IS_FLAGGED(flags)
#define UOSIMAP_IS_DELETED(flags) IMAP_IS_DELETED(flags)
#define UOSIMAP_IS_DRAFT(flags) IMAP_IS_DRAFT(flags)

#define UOSIMAP_GET_COLORLABEL(flags) IMAP_GET_COLORLABEL(flags)
#define UOSIMAP_GET_COLORLABEL_VALUE(flags) IMAP_GET_COLORLABEL_VALUE(flags)
#define UOSIMAP_SET_COLORLABEL_VALUE(flags, v) IMAP_SET_COLORLABEL_VALUE(flags, v)

UosFolderClass *uos_imap_get_class(void);

gint uos_imap_msg_set_perm_flags(UosMsgInfo *msginfo,
                             UosMsgPermFlags flags);
gint uos_imap_msg_unset_perm_flags(UosMsgInfo *msginfo,
                               UosMsgPermFlags flags);
gint uos_imap_msg_list_set_perm_flags(GSList *msglist,
                                  UosMsgPermFlags flags);
gint uos_imap_msg_list_unset_perm_flags(GSList *msglist,
                                    UosMsgPermFlags flags);

gint uos_imap_msg_list_set_colorlabel_flags(GSList *msglist,
                                        guint color);

gboolean uos_imap_is_session_active(UosIMAPFolder *folder);

int uos_imap_connect(UosPrefsAccount *account, int *ercode, char **errorchar); //add by shui
gchar *uos_imap_fetch_msg_docache(UosFolder *folder, UosFolderItem *item, gint uid); //add by shui
gint uos_imap_scan_folder_docache(UosFolder *folder, UosFolderItem *item); //add by shui
gchar *uos_imap_fetch_msg_export(UosFolder *folder, UosFolderItem *item, gint uid); //add by shui
gchar *uos_imap_fetch_large_msg(UosFolder *folder, UosFolderItem *item, gint uid); //add bu shui

void uos_set_imap_get_uncached_messages_progress_func(ImapGetUncachedMessagesProgressFunc func);
void uos_set_imap_remove_item_func(ImapRemoveItemFunc func);
void uos_set_imap_check_item_canremove_func(ImapCheckItemCanRemoveFunc func);

#endif /* __UOSIMAP_H__ */
