% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runMI-methods.R
\docType{class}
\name{lavaan.mi-class}
\alias{lavaan.mi-class}
\alias{show,lavaan.mi-method}
\alias{summary,lavaan.mi-method}
\alias{fitMeasures,lavaan.mi-method}
\alias{fitmeasures,lavaan.mi-method}
\alias{anova,lavaan.mi-method}
\alias{nobs,lavaan.mi-method}
\alias{coef,lavaan.mi-method}
\alias{vcov,lavaan.mi-method}
\alias{fitted,lavaan.mi-method}
\alias{fitted.values,lavaan.mi-method}
\alias{residuals,lavaan.mi-method}
\alias{resid,lavaan.mi-method}
\title{Class for a lavaan Model Fitted to Multiple Imputations}
\usage{
\S4method{show}{lavaan.mi}(object)

\S4method{summary}{lavaan.mi}(object, se = TRUE, ci = FALSE,
  level = 0.95, standardized = FALSE, rsquare = FALSE, fmi = FALSE,
  header = TRUE, scale.W = TRUE, asymptotic = FALSE,
  add.attributes = TRUE)

\S4method{nobs}{lavaan.mi}(object, total = TRUE)

\S4method{coef}{lavaan.mi}(object, type = "free", labels = TRUE)

\S4method{vcov}{lavaan.mi}(object, type = c("pooled", "between",
  "within", "ariv"), scale.W = TRUE)

\S4method{anova}{lavaan.mi}(object, ...)

\S4method{fitMeasures}{lavaan.mi}(object, fit.measures = "all",
  baseline.model = NULL)

\S4method{fitmeasures}{lavaan.mi}(object, fit.measures = "all",
  baseline.model = NULL)

\S4method{fitted}{lavaan.mi}(object)

\S4method{fitted.values}{lavaan.mi}(object)

\S4method{residuals}{lavaan.mi}(object, type = c("raw", "cor"))

\S4method{resid}{lavaan.mi}(object, type = c("raw", "cor"))
}
\arguments{
\item{object}{An object of class \code{lavaan.mi}}

\item{se, ci, level, standardized, rsquare, header, add.attributes}{See
\code{\link[lavaan]{parameterEstimates}}.}

\item{fmi}{\code{logical} indicating whether to include the Fraction Missing
Information (FMI) for parameter estimates in the \code{summary}
output (see \bold{Value} section).}

\item{scale.W}{\code{logical}. If \code{TRUE} (default), the \code{vcov}
method will calculate the pooled covariance matrix by scaling the
within-imputation component by the ARIV (see Enders, 2010, p. 235,
for definition and formula). Otherwise, the pooled matrix is
calculated as the weighted sum of the within-imputation and
between-imputation components (see Enders, 2010, ch. 8, for details).
This in turn affects how the \code{summary} method calcualtes its
pooled standard errors, as well as the Wald test
(\code{\link{lavTestWald.mi}}).}

\item{asymptotic}{\code{logical}. If \code{FALSE} (typically a default, but
see \bold{Value} section for details using various methods), pooled
tests (of fit or pooled estimates) will be \emph{F} or \emph{t}
statistics with associated degrees of freedom (\emph{df}). If
\code{TRUE}, the (denominator) \emph{df} are assumed to be sufficiently
large for a \emph{t} statistic to follow a normal distribution, so it
is printed as a \emph{z} statisic; likewise, \emph{F} times its
numerator \emph{df} is printed, assumed to follow a \eqn{\chi^2}
distribution.}

\item{total}{\code{logical} (default: \code{TRUE}) indicating whether the
\code{nobs} method should return the total sample size or (if
\code{FALSE}) a vector of group sample sizes.}

\item{type}{The meaning of this argument varies depending on which method it
it used for. Find detailed descriptions in the \bold{Value} section
under \code{coef}, \code{vcov}, and \code{residuals}.}

\item{labels}{\code{logical} indicating whether the \code{coef} output
should include parameter labels. Default is \code{TRUE}.}

\item{...}{Additional arguments passed to \code{\link{lavTestLRT.mi}}, or
subsequently to \code{\link[lavaan]{lavTestLRT}}.}

\item{fit.measures, baseline.model}{See \code{\link[lavaan]{fitMeasures}}.}
}
\value{
\item{coef}{\code{signature(object = "lavaan.mi", type = "free", labels = TRUE)}:
  See \code{\linkS4class{lavaan}}. Returns the pooled point estimates (i.e.,
  averaged across imputed data sets; see Rubin, 1987).}

\item{vcov}{\code{signature(object = "lavaan.mi", scale.W = TRUE,
  type = c("pooled","between","within","ariv"))}:  By default, returns the
  pooled covariance matrix of parameter estimates (\code{type = "pooled"}),
  the within-imputations covariance matrix (\code{type = "within"}), the
  between-imputations covariance matrix (\code{type = "between"}), or the
  average relative increase in variance (\code{type = "ariv"}) due to
  missing data.}

\item{fitted.values}{\code{signature(object = "lavaan.mi")}: See
  \code{\linkS4class{lavaan}}. Returns model-implied moments, evaluated at
  the pooled point estimates.}
\item{fitted}{\code{signature(object = "lavaan.mi")}:
  alias for \code{fitted.values}}

\item{residuals}{\code{signature(object = "lavaan.mi", type = c("raw","cor"))}:
  See \code{\linkS4class{lavaan}}. By default (\code{type = "raw"}), returns
  the difference between the model-implied moments from \code{fitted.values}
  and the pooled observed moments (i.e., averaged across imputed data sets).
  Standardized residuals are also available, using Bollen's
  (\code{type = "cor"} or \code{"cor.bollen"}) or Bentler's
  (\code{type = "cor.bentler"}) formulas.}
\item{resid}{\code{signature(object = "lavaan.mi", type = c("raw","cor"))}:
  alias for \code{residuals}}

\item{nobs}{\code{signature(object = "lavaan.mi", total = TRUE)}: either
  the total (default) sample size or a vector of group sample sizes
  (\code{total = FALSE}).}

\item{anova}{\code{signature(object = "lavaan.mi", ...)}:
  Returns a test of model fit for a single model (\code{object}) or test(s)
  of the difference(s) in fit between nested models passed via \code{...}.
  See \code{\link{lavTestLRT.mi}} and \code{\link{compareFit}} for details.}

\item{fitMeasures}{\code{signature(object = "lavaan.mi",
  fit.measures = "all", baseline.model = NULL)}: See lavaan's
  \code{\link[lavaan]{fitMeasures}} for details. Pass additional arguments
  to \code{\link{lavTestLRT.mi}} via \code{...}.}
\item{fitmeasures}{alias for \code{fitMeasures}.}

\item{show}{\code{signature(object = "lavaan.mi")}: returns a message about
 convergence rates and estimation problems (if applicable) across imputed
 data sets.}

\item{summary}{\code{signature(object = "lavaan.mi", se = TRUE, ci = FALSE,
 level = .95, standardized = FALSE, rsquare = FALSE, fmi = FALSE,
 scale.W = FALSE, asymptotic = FALSE, add.attributes = TRUE)}: see
 \code{\link[lavaan]{parameterEstimates}} for details.
 By default, \code{summary} returns pooled point and \emph{SE}
 estimates, along with \emph{t} test statistics and their associated
 \emph{df} and \emph{p} values. If \code{ci = TRUE}, confidence intervales
 are returned with the specified confidence \code{level} (default 95\% CI).
 If \code{asymptotic = TRUE}, \emph{z} instead of \emph{t} tests are
 returned. \code{standardized} solution(s) can also be requested by name
 (\code{"std.lv"} or \code{"std.all"}) or both are returned with \code{TRUE}.
 \emph{R}-squared for endogenous variables can be requested, as well as the
 Fraction Missing Information (FMI) for parameter estimates. By default, the
 output will appear like \code{lavaan}'s \code{summary} output, but if
 \code{add.attributes = FALSE}, the returned \code{data.frame} will resemble
 the \code{parameterEstimates} output. The \code{scale.W} argument is
 passed to \code{vcov} (see description above).}
}
\description{
This class extends the \code{\linkS4class{lavaanList}} class, created by
fitting a lavaan model to a list of data sets. In this case, the list of
data sets are multiple imputations of missing data.
}
\section{Slots}{

\describe{
\item{\code{coefList}}{\code{list} of estimated coefficients in matrix format (one
per imputation) as output by \code{\link[lavaan]{lavInspect}(fit, "est")}}

\item{\code{GLIST}}{pooled \code{list} of coefficients in GLIST format}

\item{\code{miList}}{\code{list} of modification indices output by
\code{\link[lavaan]{modindices}}}

\item{\code{seed}}{\code{integer} seed set before running imputations}

\item{\code{lavListCall}}{call to \code{\link[lavaan]{lavaanList}} used to fit the
model to the list of imputed data sets in \code{@DataList}, stored as a
\code{list} of arguments}

\item{\code{imputeCall}}{call to imputation function (if used), stored as a
\code{list} of arguments}

\item{\code{convergence}}{\code{list} of \code{logical} vectors indicating whether,
for each imputed data set, (1) the model converged on a solution, (2)
\emph{SE}s could be calculated, (3) the (residual) covariance matrix of
latent variables (\eqn{\Psi}) is non-positive-definite, and (4) the
residual covariance matrix of observed variables (\eqn{\Theta}) is
non-positive-definite.}

\item{\code{lavaanList_slots}}{All remaining slots are from
\code{\linkS4class{lavaanList}}, but \code{\link{runMI}} only populates a
subset of the \code{list} slots, two of them with custom information:}

\item{\code{DataList}}{The \code{list} of imputed data sets}

\item{\code{SampleStatsList}}{List of output from
\code{\link[lavaan]{lavInspect}(fit, "sampstat")} applied to each fitted
model}

\item{\code{ParTableList}}{See \code{\linkS4class{lavaanList}}}

\item{\code{vcovList}}{See \code{\linkS4class{lavaanList}}}

\item{\code{testList}}{See \code{\linkS4class{lavaanList}}}
}}

\section{Objects from the Class}{
 See the \code{\link{runMI}} function for
  details. Wrapper functions include \code{\link{lavaan.mi}},
  \code{\link{cfa.mi}}, \code{\link{sem.mi}}, and \code{\link{growth.mi}}.
}

\examples{

## See ?runMI help page

}
\references{
Asparouhov, T., & Muthen, B. (2010). \emph{Chi-square statistics
  with multiple imputation}. Technical Report. Retrieved from
  \url{www.statmodel.com}

  Enders, C. K. (2010). \emph{Applied missing data analysis}. New York, NY:
  Guilford.

  Li, K.-H., Meng, X.-L., Raghunathan, T. E., & Rubin, D. B. (1991).
  Significance levels from repeated \emph{p}-values with multiply-imputed
  data. \emph{Statistica Sinica, 1}(1), 65--92. Retrieved from
  \url{https://www.jstor.org/stable/24303994}

  Meng, X.-L., & Rubin, D. B. (1992). Performing likelihood ratio tests with
  multiply-imputed data sets. \emph{Biometrika, 79}(1), 103--111. Retrieved
  from \url{https://www.jstor.org/stable/2337151}

  Rubin, D. B. (1987). \emph{Multiple imputation for nonresponse in surveys}.
  New York, NY: Wiley.
}
\author{
Terrence D. Jorgensen (University of Amsterdam;
  \email{TJorgensen314@gmail.com})
}
