use ui;
use core:geometry;
use graphics;
use core:io;
use core:lang;

Font nFont() {
	Font f = defaultFont();
	f.height = f.height * 1.3;
	f;
}

// Font nodeFont on Render = defaultFont();
Font nodeFont on Render = nFont();
Brush nodeBrush on Render = SolidBrush(black);

class Node on Render {
	Point at;
	Text text;
	Node? left;
	Node? right;

	init(Point at, Str label) {
		init {
			at = at;
			text = Text(label, nodeFont);
		}

		this.at -= text.size / 2;
	}

	init(Node original) {
		init {
			at = original.at;
			text = original.text;
			left = original.left;
			right = original.right;
		}
	}

	Point top() {
		at + Point(text.size.w / 2, 0);
	}

	Point bottomLeft() {
		at + Point(0, text.size.h);
	}

	Point bottomRight() {
		at + text.size;
	}

	void replace(Node from, Node? to) {
		if (left is from)
			left = to;
		if (right is from)
			right = to;
	}

	void draw(Graphics g) {
		// g.fill(Rect(at, text.size), nodeBg);
		g.draw(text, nodeBrush, at);

		if (left) {
			g.line(bottomLeft, left.top, nodeBrush);
		}
		if (right) {
			g.line(bottomRight, right.top, nodeBrush);
		}
	}

	Bool contains(Point pt) {
		Rect(at, text.size).contains(pt);
	}
}


class SimpleNode {
	Str text;
	SimpleNode? left;
	SimpleNode? right;

	init(Str text) {
		init { text = text; }
	}

	void left(SimpleNode? l) {
		left = l;
	}

	void right(SimpleNode? r) {
		right = r;
	}
}

SimpleNode? parseFile(Url file) on Compiler {
	Parser<SRoot> parser;
	parser.parse(file.readAllText(), file);
	if (parser.hasError)
		parser.throwError();
	parser.tree.transform();
}
